



<html>
<head>
  <title>javabog.dk -  - Samlinger af data</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel0.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">1 <a name='afsn1'></a>Samlinger af
data</H1>
<DIV ID="Indholdsfortegnelse6">
  <P STYLE="margin-top: 0.3cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.1
  Lister og m&aelig;ngder  24</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.1.1
  De simple typer og samlinger af data  25</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.1.2
  Interfacene til lister og m&aelig;ngder  25</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.1.3
  Lister  26</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.1.4
  M&aelig;ngder  26</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.1.5
  Iteratorer  27</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.2
  Afbildninger (n&oslash;gleindekserede lister)  28</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.2.1
  Afbildninger (Interfacet Map)  28</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.2.2
  Hashtabeller (klassen HashMap)  29</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.2.3
  Eksempel - ordbog  29</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.2.4
  Eksempel - f&oslash;dselsdatoer  30</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.2.5
  Klassen LinkedHashMap  31</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.2.6
  Interfacet SortedMap (sorterede afbildninger) og klassen TreeMap  31</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.3
  Opgaver  31</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.4
  Videre l&aelig;sning  31</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.5
  Appendiks  32</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.5.1
  Collection  32</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.5.2
  Set  32</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.5.3
  SortedSet  32</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.5.4
  List  33</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.5.5
  Map  34</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.5.6
  Iteratorer  35</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.5.7
  Manipulation og sortering af data  36</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.6
  Avanceret  38</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.6.1
  Store-O-notationen  38</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.6.2
  Arraybaserede listers virkem&aring;de  38</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.6.3
  H&aelig;gtede listers virkem&aring;de  39</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.6.4
  Hashtabellers virkem&aring;de  39</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.6.5
  S&oslash;getr&aelig;ers virkem&aring;de  39</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.6.6
  Uforanderlige samlinger  40</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.6.7
  Tr&aring;dsikre samlinger  40</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.6.8
  Uddrag af kildeteksten til Vector-klassen  41</FONT></FONT></P>
</DIV>



<P CLASS="kapiteloversigt-western">En overfladisk forst&aring;else af
dette kapitel (is&aelig;r lister) foruds&aelig;ttes i det meste af
bogen.</P>
<P CLASS="western" STYLE="">En samling
(eng.: collection) er en datastruktur, der husker p&aring; en samling
objekter. 
</P>
<P CLASS="western">Med JDK1.2 blev der tilf&oslash;jet en r&aelig;kke
klasser til <SPAN LANG="da-DK">java.util</SPAN>-pakken, og de bliver
under et bliver betegnet collections-klasserne. De kan meget mere end
Vector og Hashtable, og det anbefales at bruge de nye klasser til
programmer, der ikke beh&oslash;ver at kunne k&oslash;re under
JDK1.1.8 eller tidligere.</P>
<H2 CLASS="western">1.1 <a name='afsn1.1'></a>Lister og m&aelig;ngder</SPAN></H2>
<P CLASS="western">Den mest almindelige liste er ArrayList, en liste,
der husker sine objekter, som l&aring; de som perler p&aring; en snor
lige som den gamle Vector-klasse. Man opretter en ArrayList med
f.eks.:</P>
<PRE CLASS="kode-western">  ArrayList liste;
  liste = new ArrayList();</PRE><P CLASS="western">
Derefter kan man tilf&oslash;je et objekt i enden af listen med <B>add</B>(
objekt ), f.eks.:</P>
<PRE CLASS="kode-western">  <SPAN LANG="da-DK">liste.add</SPAN>(&quot;&aelig;h&quot;);</PRE><P CLASS="western">
tilf&oslash;jer strengen &quot;&aelig;h&quot; sidst i listen.</P>
<P CLASS="western">Man kan s&aelig;tte ind midt i listen med <B>add</B>(
objekt, indeks ), f.eks.:</P>
<PRE CLASS="kode-western">  liste.add(&quot;&oslash;h&quot;,0);</PRE><P CLASS="western">
inds&aelig;tter &quot;&oslash;h&quot; p&aring; plads nummer 0, s&aring;dan
at listen nu indeholder f&oslash;rst &quot;&oslash;h&quot; og s&aring;
&quot;&aelig;h&quot;. Alle elementerne fra og med det indeks, hvori
man inds&aelig;tter, f&aring;r alts&aring; rykket deres indeks et
frem. Ligeledes rykkes alle de efterf&oslash;lgende elementer, hvis
man fjerner et element med metoden <B>remove</B>( indeks ).</P>
<P CLASS="western">Man henter elementerne ud igen med <B>get</B>(
indeks ).</P>
<P CLASS="western">Med <SPAN LANG="da-DK">liste.<B>size</B></SPAN>()
f&aring;r man antallet af elementer i listen, i dette tilf&aelig;lde
2.</P>
<P ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Nogle
af metoderne i List-klasserne (s&aring; som ArrayList og LinkedList)</I></FONT></P>
<P CLASS="klasseoversigt-western"><B>Metoder</B></P>
<P CLASS="klasseoversigt-western">boolean <B>add</B>( objekt )<BR>F&oslash;jer
<I>objekt</I><SPAN STYLE="font-style: normal"> til listen (sidst).
Objektet kan v&aelig;re af en vilk&aring;rlig klasse. Simple typer
(som int og double) tillades ikke (se <a href='kapitel1.jsp#afsn1.1.1'>afsnit 1.1.1</a>). Returnerer altid
true.</SPAN></P>
<P CLASS="klasseoversigt-western">void <B>add</B>( objekt, int indeks
)<BR>Inds&aelig;tter <I>objekt</I><SPAN STYLE="font-style: normal"> i
listen lige f&oslash;r plads nummer </SPAN><I>indeks</I>.</P>
<P CLASS="klasseoversigt-western">void <B>remove</B>( int indeks
)<BR>Sletter objektet p&aring; <SPAN STYLE="font-style: normal">plads
nummer </SPAN><I>indeks</I>.</P>
<P CLASS="klasseoversigt-western">boolean <B>remove</B>( objekt
)<BR>Sletter <I>objekt</I> fra listen, hvis det findes. Hvis det
fandtes, returneres true, ellers false. 
</P>

<P CLASS="klasseoversigt-western">int <B>size</B>()<BR>Returnerer
antallet af elementer i listen.</P>
<P CLASS="klasseoversigt-western">Object <B>get</B>( int indeks
)<BR>Returnerer en reference til objektet p&aring; plads nummer
<I>indeks</I><SPAN STYLE="font-style: normal">. Husk at lave en
typekonvertering af referencen til den rigtige klasse, f&oslash;r
resultatet l&aelig;gges i en variabel. Listen selv bliver ikke
&aelig;ndret.</SPAN></P>
<P CLASS="klasseoversigt-western">String <B>toString</B>
()<BR>Returnerer listens indhold som en streng. Dette sker ved at
konvertere hver af elementerne til en streng.</P>
<P CLASS="western">Ovenst&aring;ende beskrivelse g&aelig;lder ikke
kun ArrayList, men er en beskrivelse af et interface, der g&aelig;lder
for alle List-objekter (lister), herunder ArrayList. Vi vil senere se
p&aring; et andet List-objekt, nemlig LinkedList.</P>
<H3 CLASS="western">1.1.1 <a name='afsn1.1.1'></a>De simple typer og samlinger af data</H3>
<P CLASS="western">Ligesom Vector kan lister (eller nogen af de andre
nye samlinger) kun indeholde objekter, men ikke de simple typer som
int og double:</P>
<PRE CLASS="ikke-javakode-western">  liste.add( 5 );                   <I>// forkert!</I>
  liste.add( 3.14 );                <I>// forkert!</I></PRE><P CLASS="western">
Man er n&oslash;dt til at pakke dem ind i objekter, der svarer til de
simple typer, f.eks.:</P>
<PRE CLASS="ikke-javakode-western">  liste.add( new Integer(5) );      <I>// rigtigt</I>
  liste.add( new Double(3.14) );    <I>// rigtigt</I></PRE><H3 CLASS="western">
1.1.2 <a name='afsn1.1.2'></a>Interfacene til lister og m&aelig;ngder</H3>
<P CLASS="western">I stedet for bare at levere nogle klasser, som
programm&oslash;rerne s&aring; kan bruge (som med f.eks. Vector), er
alle de v&aelig;sentlige metoder beskrevet i interfaces, og der
findes s&aring; flere forskellige implementationer af interfacene
(klasser) til forskelligt brug.</P>
<P CLASS="western">Interfacene er vist herunder sammen med klasserne,
der implementerer dem.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog2_html_4841fe8d.gif" NAME="Grafik55" ALIGN=BOTTOM BORDER=0></P>

<H4 CLASS="western">Interfacet Collection (samlinger af data)</H4>
<P CLASS="western">Interfacet Collection (da.: samling) beskriver en
samling data og indeholder metoder f&aelig;lles for alle samlinger af
data. 
</P>
<P CLASS="western">Der er ikke nogen klasser, der direkte
implementerer Collection. I stedet implementerer de interfacene List,
Set eller SortedSet, der udbygger (arver fra) Collection.</P>
<H3 CLASS="western" STYLE="">1.1.3 <a name='afsn1.1.3'></a>Lister</H3>
<P CLASS="western">List beskriver en <I>ordnet</I> liste af elementer
(dvs. elementerne har en r&aelig;kkef&oslash;lge og hvert element har
en plads, ligesom med Vector). 
</P>
<P CLASS="western">Den indeholder derfor (ud over dem i Collection)
metoder, der foruds&aelig;tter at elementerne har et index, som
f.eks. get(int index), Object remove(int index) og set(int index,
Object element). Da hvert element identificeres med et indeks, kan
der godt v&aelig;re dubletter (dvs. det samme element optr&aelig;der
flere gange i listen p&aring; forskellige indeks). Eksempel p&aring;
brug:</P>
<PRE CLASS="ikke-javakode-western">List l = new ArrayList();      <I>// variablen er bare af interfacets type</I>
l.add(&quot;En&quot;);
l.add(&quot;snegl&quot;);</PRE><P CLASS="western">
L&aelig;g m&aelig;rke til, at man ofte bare lader variablen v&aelig;re
af <I>interfacets</I> type. Det g&oslash;r, at man nemt kunne &aelig;ndre
ovenst&aring;ende kode til at bruge LinkedList eller en anden samling
i stedet (der skal kun &aelig;ndres fra &quot;new ArrayList()&quot;
til &quot;new LinkedList()&quot;.</P>
<P CLASS="western">Der findes to klasser, der implementerer List,
nemlig ArrayList og LinkedList. Udefra bruges de p&aring; helt samme
m&aring;de (og har de samme metoder), men de fungerer forskelligt
indeni.</P>
<H4 CLASS="western">ArrayList</H4>
<P CLASS="western">ArrayList bruger internt et array til at gemme
sine data, og svarer til den gamle Vector-klasse (men ArrayList er
dog lidt hurtigere end Vector, da dens metoder ikke er
synkroniseret).</P>
<P CLASS="western">Den er derfor hurtig at finde elementer i, men
langsom, hvis elementer skal inds&aelig;ttes et vilk&aring;rligt sted
i listen (da de andre elementer i <SPAN LANG="da-DK">arrayet</SPAN>
s&aring; skal rykkes). Se <a href='kapitel1.jsp#afsn1.6.2'>afsnit 1.6.2</a> for en n&aelig;rmere
diskussion af <SPAN LANG="da-DK">ArrayList's</SPAN> virkem&aring;de.</P>
<H4 CLASS="western">LinkedList</H4>
<P CLASS="western">LinkedList bruger internt en <SPAN LANG="da-DK">dobbelth&aelig;gtet</SPAN>
liste til at gemme sine data. I en dobbelth&aelig;gtet liste gemmes
data led i en k&aelig;de: hver indgang har en reference til (&quot;er
h&aelig;gtet&quot; med) forrige og n&aelig;ste indgang. 
</P>
<P CLASS="western">Skal man s&oslash;ge et bestemt index frem i en
s&aring;dan liste, g&aring;r det langsomt: Man m&aring; starte fra en
ende og s&aring; l&oslash;be gennem hver indgang (&quot;led i
k&aelig;den&quot;), indtil den &oslash;nskede indgang n&aring;s. Det
er til geng&aelig;ld meget hurtigt at f&oslash;je nye elementer til
listen (da de andre elementer ikke beh&oslash;ves at blive rykket).
Se <a href='kapitel1.jsp#afsn1.6.3'>afsnit 1.6.3</a> for en n&aelig;rmere diskussion af <SPAN LANG="da-DK">LinkedList's</SPAN>
virkem&aring;de.</P>
<H3 CLASS="western">1.1.4 <a name='afsn1.1.4'></a>M&aelig;ngder</H3>
<H4 CLASS="western">Interfacet Set</H4>
<P CLASS="western">Set (da.: m&aelig;ngde) beskriver en <SPAN LANG="da-DK">uordnet</SPAN>
m&aelig;ngde af elementer. I en m&aelig;ngde kan der h&oslash;jest
v&aelig;re en af hvert element, og elementerne ligger &quot;hulter
til bulter&quot; mellem hinanden, dvs. r&aelig;kkef&oslash;lgen, som 
elementerne blev sat ind, huskes ikke. Den indeholder ingen metoder,
ud over metoderne fra Collection.</P>
<H4 CLASS="western">Klassen <SPAN LANG="da-DK">HashSet</SPAN></H4>
<P CLASS="western">Klassen HashSet implementerer Set. Den bruger en
hashtabel til at holde styr p&aring; elementerne. En hashtabel er en
opslagstabel, der laves ud fra objekternes hashkode (se <a href='kapitel1.jsp#afsn1.6.4'>afsnit 1.6.4</a>).
Hashtabeller er meget hurtige at s&oslash;ge og inds&aelig;tte i.
Eksempel p&aring; brug:</P>
<PRE CLASS="ikke-javakode-western">Set m = new HashSet();      <I>// variablen er bare af interfacets type</I>

<SPAN LANG="da-DK">m.addAll</SPAN>( l );              <I>// tilf&oslash;j alle elementer fra listen l</I>
<SPAN LANG="da-DK">m.add</SPAN>(&quot;er&quot;);
m.add(&quot;tegn&quot;);</PRE><P CLASS="western">
Se <a href='kapitel1.jsp#afsn1.6.4'>afsnit 1.6.4</a> for en diskussion af hashtabellers interne virkem&aring;de.</P>
<H4 CLASS="western">Sorterede m&aelig;ngder (Interfacet SortedSet og
klassen <SPAN LANG="da-DK">TreeSet</SPAN>)</H4>
<P CLASS="western">SortedSet beskriver en ordnet m&aelig;ngde af
elementer (dvs. elementerne har en r&aelig;kkef&oslash;lge, og der
kan h&oslash;jest v&aelig;re &eacute;n af hver).</P>
<P CLASS="western">Klassen TreeSet implementerer SortedSet. Den
bruger et bin&aelig;rt s&oslash;getr&aelig; til at holde styr p&aring;
elementerne (se <a href='kapitel1.jsp#afsn1.6.5'>afsnit 1.6.5</a>). 
</P>
<P CLASS="western">Ordningen (dvs. hvordan elementerne skal sorteres)
kan bestemmes ved at angive et Comparator-objekt i konstrukt&oslash;ren
til TreeSet (ellers skal elementerne v&aelig;re Comparable).</P>
<P CLASS="western">Eksempel p&aring; brug:</P>
<PRE CLASS="ikke-javakode-western">SortedSet sm = new TreeSet(); <I>// variablen er bare af interfacets type</I>

<SPAN LANG="da-DK">sm.addAll</SPAN>( m );               <I>// tilf&oslash;j alle elementer fra m&aelig;ngden m</I>
<SPAN LANG="da-DK">sm.add</SPAN>(&quot;p&aring;&quot;);
sm.add(&quot;regn&quot;);</PRE><H3 CLASS="western">
1.1.5 <a name='afsn1.1.5'></a>Iteratorer</H3>
<P CLASS="western">En iterator er et lille objekt, der hj&aelig;lper
med at genneml&oslash;be nogle data.</P>
<P CLASS="western">I stedet for at bruge en t&aelig;llevariabel:</P>
<PRE CLASS="kode-western">for (int i=0; i&lt;liste.size(); i++) {                      <I>// uden iterator</I>
  String s = (String) <SPAN LANG="da-DK">liste.get</SPAN>(i);
  <I>// g&oslash;r noget med s</I>
  System.out.println(s);
}</PRE><P CLASS="western">
... kan man alts&aring; f&aring; et iterator-objekt ved at kalde
metoden iterator() og bruge det:</P>
<PRE CLASS="kode-western">for (<B>Iterator <SPAN LANG="da-DK">iter</SPAN>=<SPAN LANG="da-DK">liste.iterator</SPAN>(); <SPAN LANG="da-DK">iter.hasNext</SPAN>(); </B>) {  <I>// med iterator</I>
  String s = (String) <B><SPAN LANG="da-DK">iter.next</SPAN>()</B>;
  <I>// g&oslash;r noget med s</I>
  System.out.println(s);
}</PRE><P CLASS="western">
Her er det samme skrevet om til at bruge en while-l&oslash;kke
(hvilket g&oslash;r det lidt enklere):</P>
<PRE CLASS="kode-western">Iterator <B>iter=<SPAN LANG="da-DK">samling.iterator</SPAN>()</B>;                         <I>// med iterator</I>
while (<B>iter.hasNext()</B>) {
  String s = (String) <B>iter.next()</B>;
  <I>// g&oslash;r noget med s</I>
  System.out.println(s);
}</PRE><P CLASS="western">
... der alts&aring; svarer til:</P>
<PRE CLASS="kode-western">int i = 0;                                                <I>// uden iterator</I>
while (i&lt;liste.size()) {
  String s = (String) liste.get(i);
  <I>// g&oslash;r noget med s</I>
  System.out.println(s);
  i++;
}</PRE>
<P CLASS="western">Iterator-objekter har alts&aring; to<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>
vigtige metoder: 
</P>
<P CLASS="klasseoversigt-western">boolean <B><SPAN LANG="da-DK">hasNext</SPAN></B>()
<BR>fort&aelig;ller, om der er flere elementer i 
</P>
<P CLASS="klasseoversigt-western">Object <B>next</B>() <BR>g&aring;r
til n&aelig;ste element og returnerer det samtidig.</P>
<P CLASS="western">Alle samlinger af data har metoden iterator(), der
returnerer et Iterator-objekt. Iteratorer kan alts&aring; bruges p&aring;
enhver samling af data, ogs&aring; p&aring; f.eks. m&aelig;ngder,
hvor en almindelig t&aelig;llevariabel kommer til kort.</P>
<H2 CLASS="western" STYLE="">1.2 <a name='afsn1.2'></a>Afbildninger
(n&oslash;gleindekserede lister)</SPAN></H2>
<P CLASS="western">En afbildning (eng.: map) er noget, der afbilder
nogle n&oslash;gler til v&aelig;rdier. Afbildninger er nyttige, n&aring;r
man vil indeksere nogle objekter ud fra f.eks. et navn i stedet for
et nummer.</P>
<H4 CLASS="western">Afbildninger i forhold til lister</H4>
<P CLASS="western">F&oslash;r vi g&aring;r videre, s&aring; husk, at
lister <SPAN STYLE="font-weight: medium"><I>g&aring;r fra heltal til
objekter</I><SPAN STYLE="font-style: normal">, dvs. hvert element
har en plads og et nummer. For eksempel har en liste metoderne:</SPAN></SPAN></P>
<P CLASS="klasseoversigt-western">void <B>add</B>( objekt, int indeks
)<BR>Inds&aelig;tter <I>objekt</I><SPAN STYLE="font-style: normal"> i
listen lige f&oslash;r plads nummer </SPAN><I>indeks.</I></P>
<P CLASS="klasseoversigt-western">Object <B>get</B>( int indeks
)<BR>Returnerer en reference til objektet p&aring; plads nummer
<I>indeks</I><SPAN STYLE="font-style: normal"> i listen.</SPAN></P>
<P CLASS="western">Man kan ogs&aring; sige, at elementerne i en liste
indekseres (<SPAN LANG="da-DK">fremfindes</SPAN>) ud fra et tal.</P>
<H3 CLASS="western">1.2.1 <a name='afsn1.2.1'></a>Afbildninger (Interfacet Map)</H3>
<P CLASS="western">Afbildninger <SPAN STYLE="font-weight: medium"><I>g&aring;r
fra objekter til objekter</I><SPAN STYLE="font-style: normal"> p&aring;
den m&aring;de, at til hvert element knyttes et n&oslash;gle-objekt.
Elementerne kan derefter findes frem ud fra n&oslash;glerne.</SPAN></SPAN></P>
<P CLASS="western" STYLE="font-style: normal; font-weight: medium">Man
kan alts&aring; sige, at elementerne (v&aelig;rdierne) i en
afbildning indekseres (fremfindes) ud fra n&oslash;glerne, og at en
afbildning best&aring;r af nogle n&oslash;gle-v&aelig;rdi-par. 
</P>
<P CLASS="western" STYLE="font-style: normal; font-weight: medium">Interfacet
Map beskriver metoderne, der kan kaldes p&aring; en afbildning.</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Nogle
af Map-klassernes metoder - afbildning eller <SPAN LANG="da-DK">n&oslash;gleindekseret</SPAN>
liste af objekter (se appendiks for fuld liste)</I></FONT></P>
<P CLASS="klasseoversigt-western">void <B>put</B>(Object n&oslash;gle,
Object v&aelig;rdi)<BR>f&oslash;jer <SPAN STYLE="font-style: normal">objektet</SPAN>
<I>v&aelig;rdi</I><SPAN STYLE="font-style: normal"> til afbildningen
under objektet </SPAN><I>n&oslash;gle</I><SPAN STYLE="font-style: normal">.
Objekterne kan v&aelig;re et vilk&aring;rligt objekt (men ikke
en simpel type).</SPAN></P>
<P CLASS="klasseoversigt-western">Object <B>get</B>(Object
n&oslash;gle)<BR>finder indgangen under <I>n&oslash;gle</I><SPAN STYLE="font-style: normal">
og returnerer v&aelig;rdien. Husk at lave en typekonvertering af
referencen til den rigtige klasse, f&oslash;r resultatet l&aelig;gges
i en variabel.</SPAN></P>
<P CLASS="klasseoversigt-western">Object <B>remove</B>(Object
n&oslash;gle)<BR>sletter indgangen under <I>n&oslash;gle</I><SPAN STYLE="font-style: normal">
og returnerer v&aelig;rdien.</SPAN></P>
<P CLASS="klasseoversigt-western">boolean <B><SPAN LANG="da-DK">isEmpty</SPAN></B>()<BR>returnerer
sand, hvis afbildningen er tom (indeholder 0 indgange)<SPAN STYLE="font-style: normal">.</SPAN></P>
<P CLASS="klasseoversigt-western">int <B>size</B>()<BR>returnerer
antallet af indgange (n&oslash;gle-v&aelig;rdi-par)<SPAN STYLE="font-style: normal">.</SPAN></P>
<P CLASS="klasseoversigt-western">boolean <B><SPAN LANG="da-DK">containsKey</SPAN></B>(Object
n&oslash;gle)<BR>returnerer sand, hvis <I>n&oslash;gle</I> <SPAN STYLE="font-style: normal">findes
blandt n&oslash;glerne i afbildningen.</SPAN></P>
<P CLASS="klasseoversigt-western">boolean <B><SPAN LANG="da-DK">containsValue</SPAN></B>(Object
v&aelig;rdi)<BR>returnerer sand, hvis <I>v&aelig;rdi</I> <SPAN STYLE="font-style: normal">findes
blandt v&aelig;rdierne i  afbildningen.</SPAN></P>
<P CLASS="klasseoversigt-western">Set <B><SPAN LANG="da-DK">keySet</SPAN></B><SPAN STYLE="font-weight: medium">()<BR>giver
en datastruktur (en m&aelig;ngde) af <SPAN STYLE="font-style: normal">afbildningens</SPAN>
n&oslash;gler. Kan v&aelig;re nyttigt, hvis man vil genneml&oslash;be
alle indgangene i afbildningen. </SPAN>
</P>
<P CLASS="klasseoversigt-western">String <B>toString</B>
()<BR>Returnerer alle <SPAN STYLE="font-weight: medium"><SPAN STYLE="font-style: normal">afbildningens
</SPAN></SPAN>indgange som &eacute;n stor streng. Dette sker ved at
konvertere hver af indgangenes n&oslash;gler og v&aelig;rdier
til strenge.</P>


<P CLASS="western" STYLE=""><SPAN STYLE="font-weight: medium"><SPAN STYLE="font-style: normal">Klassen
HashMap er den eneste, der implementerer Map-interfacet</SPAN></SPAN>
direkte<SPAN STYLE="font-weight: medium"><SPAN STYLE="font-style: normal">
(indirekte er der to til, nemlig klassen LinkedHashMap, der kom til i
JDK1.4, og klassen TreeMap).</SPAN></SPAN></P>
<P CLASS="western" ALIGN=CENTER STYLE="font-style: normal; font-weight: medium">
<IMG SRC="bog2_html_5e19a132.gif" NAME="Grafik38" ALIGN=BOTTOM BORDER=0></P>
<H3 CLASS="western">1.2.2 <a name='afsn1.2.2'></a>Hashtabeller (klassen HashMap)</H3>
<P CLASS="western">Man opretter en afbildning (i dette tilf&aelig;lde
en hashtabel) med f.eks.:</P>
<PRE CLASS="kode-western">  Map tabel;
  tabel = new HashMap();</PRE><P CLASS="western">
Derefter kan man l&aelig;gge en indgang i tabellen med <B>put</B>(
n&oslash;gle, v&aelig;rdi ). F.eks.:</P>
<PRE CLASS="kode-western">  <SPAN LANG="da-DK">tabel.put</SPAN>(&quot;abc&quot;, &quot;<SPAN LANG="da-DK">def</SPAN>&quot;);</PRE><P CLASS="western">
husker strengen &quot;def&quot; under n&oslash;glen &quot;abc&quot;.
Vil vi finde strengen frem igen, skal vi sl&aring; op under &quot;abc&quot;:</P>
<PRE CLASS="kode-western">  String v&aelig;rdi = (String) <SPAN LANG="da-DK">tabel.get</SPAN>(&quot;abc&quot;);</PRE>
<P CLASS="western">HashMap afl&oslash;ser den gamle HashTable-klasse
og kan nogenlunde det samme. Da hashtabeller oftest anvendes til at
lave afbildninger med, bruger man i dagligdags sprogbrug mere ordet
'hashtabel' end ordet 'afbildning'.</P>
<H3 CLASS="western">1.2.3 <a name='afsn1.2.3'></a>Eksempel - ordbog</H3>
<P CLASS="western" STYLE="font-style: normal; font-weight: medium">Vi
kunne f.eks. bruge en afbildning (HashMap) til at lave en lille
esperanto-dansk-ordbog med. N&oslash;glerne er esperanto-ordene, og
v&aelig;rdierne er de danske ord. 
</P>
<PRE CLASS="kode-western">import java.util.*;

public class <SPAN LANG="da-DK">BenytHashMapOrdbog</SPAN>
{
  public static void main(String[] args)
  {
    HashMap <B>ord = new HashMap()</B>;
    <B><SPAN LANG="da-DK">ord.put</SPAN>(&quot;<SPAN LANG="da-DK">granda</SPAN>&quot;, &quot;stor&quot;)</B>;
    <B>ord.put(&quot;<SPAN LANG="da-DK">longa</SPAN>&quot;, &quot;lang&quot;)</B>;
    <B>ord.put(&quot;hundo&quot;, &quot;hund&quot;)</B>;
    <B>ord.put(&quot;<SPAN LANG="da-DK">estas</SPAN>&quot;, &quot;(det) er&quot;)</B>;

    String <SPAN LANG="da-DK">esperantotekst</SPAN> = &quot;<SPAN LANG="da-DK">Estas</SPAN> longa granda hundo.&quot;;
    <SPAN LANG="da-DK">StringTokenizer</SPAN> st = new StringTokenizer(esperantotekst, &quot; .,\t\n&quot;, true);
    while (<SPAN LANG="da-DK">st.hasMoreTokens</SPAN>()) {
      String da, eo;
      eo = <SPAN LANG="da-DK">st.nextToken</SPAN>()<SPAN LANG="da-DK">.toLowerCase</SPAN>();
      <B>da = (String) <SPAN LANG="da-DK">ord.get</SPAN>(eo)</B>;<I>// sl&aring; <SPAN LANG="da-DK">esperantoordet</SPAN> op og f&aring; det danske ord</I>
      if (da == null) da = eo;  <I>// hvis <SPAN LANG="da-DK">intet</SPAN> fundet lader vi det v&aelig;re uoversat</I>
      System.out.print( da );
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">(det) er lang stor hund.</PRE><P CLASS="western" STYLE="font-style: normal; font-weight: medium">
Har vi en tekst p&aring; esperanto, kan vi nu overs&aelig;tte teksten
ord for ord til dansk. Hvert ord sl&aring;s op i hashtabellen, og
hvis det findes, erstattes det med det danske ord. Ord som ikke kan
findes, efterlades uforandret.</P>
<H3 CLASS="western">1.2.4 <a name='afsn1.2.4'></a>Eksempel - f&oslash;dselsdatoer</H3>
<P CLASS="western">N&oslash;glerne og v&aelig;rdierne beh&oslash;ver
ikke v&aelig;re strenge. I eksemplet herunder opretter vi en
hashtabel, der holder styr p&aring; f&oslash;dselsdatoer for et antal
personer ud fra deres fornavne.</P>
<PRE CLASS="kode-western">import java.util.*;

public class <SPAN LANG="da-DK">BenytHashMapDatoer</SPAN>
{
  public static void main(String[] args)
  {
    HashMap <B>hashtabel = new HashMap()</B>;
    Date dato;

    dato = new Date(71,0,1);                <I>//  1. januar 1971</I>
    <B><SPAN LANG="da-DK">hashtabel.put</SPAN>(&quot;Jacob&quot;,dato)</B>;

    dato = new Date(72,7,11);               <I>// 11. august 1972</I>
    <B>hashtabel.put(&quot;Troels&quot;,dato)</B>;

    <B>hashtabel.put(&quot;Ulrik&quot;,new Date(73,2,5))</B>;<I>//  5. marts 1973</I>
    <B>hashtabel.put(&quot;Ulla&quot;,new Date(69,1,19))</B>;<I>// 19. februar 1969</I>
    <B>hashtabel.put(&quot;Brian&quot;,new Date(70,3,1))</B>;<I>//  1. april 1970</I>
    <B>hashtabel.put(&quot;Bo&quot;,new Date(76,6,9))</B>;<I>// 9. juli 1976</I>

<I>    // Lav nogle opslag i tabellen under forskellige navne</I>
    dato = (Date) <B><SPAN LANG="da-DK">hashtabel.get</SPAN>(&quot;Troels&quot;)</B>;
    System.out.println( &quot;Opslag under Troels giver: &quot;+dato);

    System.out.println( &quot;Opslag under Jacob:     &quot;+<B>hashtabel.get(&quot;Jacob&quot;)</B>);
    System.out.println( &quot;Opslag under <SPAN LANG="da-DK">Kurtb&oslash;rge</SPAN>: &quot;+<B>hashtabel.get(&quot;Kurtb&oslash;rge&quot;)</B>);
    System.out.println( &quot;Opslag under Brian:     &quot;+<B>hashtabel.get(&quot;Brian&quot;)</B>);

<I>    // Genneml&oslash;b af alle elementer</I>
    <B>for (Iterator i = <SPAN LANG="da-DK">hashtabel.keySet</SPAN>()<SPAN LANG="da-DK">.iterator</SPAN>() ; <SPAN LANG="da-DK">i.hasNext</SPAN>() ;) {</B>
      String <B>n&oslash;gle = (String) i.next()</B><SPAN STYLE="font-weight: medium">;</SPAN>
<SPAN STYLE="font-weight: medium">  </SPAN>    dato = (Date) <B>hashtabel.get(n&oslash;gle)</B>;
      System.out.println(n&oslash;gle + &quot; har f&oslash;dsels&aring;ret: &quot;+<SPAN LANG="da-DK">dato.getYear</SPAN>());
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">xxx udskrift genereres igen
Opslag under 'Troels' giver: Fri Aug 11 00:00:00 GMT+00:00 1972
.. og under Jacob: Fri Jan 01 00:00:00 GMT+00:00 1971
.. Kurtb&oslash;rge: null
.. Eva: Mon Mar 05 00:00:00 GMT+00:00 1973
Jacob's f&oslash;dsels&aring;r: 71
<SPAN LANG="da-DK">Ulla's</SPAN> f&oslash;dsels&aring;r: 69
Eva's f&oslash;dsels&aring;r: 73
Troels's f&oslash;dsels&aring;r: 72</PRE><P CLASS="western">
De sidste linjer i koden viser, hvordan man genneml&oslash;ber alle
indgangene i en afbildning. Vi kan ikke, som med en liste, bare lave
en for-l&oslash;kke, der l&oslash;ber fra 0 til antal elementer.
I stedet skaffer vi m&aelig;ngden af alle n&oslash;gler med
hashtabel.keySet() og kalder derefter .iterator() for at f&aring; et
Iterator-objekt, der genneml&oslash;ber n&oslash;glerne, hvorefter vi
for hver n&oslash;gle fremfinder v&aelig;rdien<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.</P>
<P CLASS="western">Bem&aelig;rk hvordan en HashMap ikke husker
r&aelig;kkef&oslash;lgen af indgangene. Derfor er r&aelig;kkef&oslash;lgen,
som elementerne bliver udskrevet i (Jacob, Ulla, Brian, Troels, Ulrik
ogBo xxx tjek), ikke den samme som den r&aelig;kkef&oslash;lge, de
blev sat ind i (Jacob, Troels, Ulrik, Ulla, Brian og Bo).</P>
<H3 CLASS="western">1.2.5 <a name='afsn1.2.5'></a>Avanceret: LinkedHashMap i JDK 1.4</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.2.5">
  <input type='checkbox' name='vis' value='1.2.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.2.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">1.2.6 <a name='afsn1.2.6'></a>Interfacet SortedMap (sorterede
afbildninger) og klassen TreeMap</H3>
<P CLASS="western">Dette er en afbildning, hvor n&oslash;glerne er
sorteret p&aring; samme m&aring;de som SortedSet. Klassen TreeMap er
den eneste, der implementerer SortedMap.</P>
<H2 CLASS="western">1.3 <a name='afsn1.3'></a>Opgaver</SPAN></H2>
<OL>
  <LI><P CLASS="western">Lav et lille ordliste-program: Det skal tage
  en tekst og finde frem til de ord, der indg&aring;r i teksten, gemme
  dem i en ArrayList og derefter skrive listen p&aelig;nt ud.<BR>Vink:
  StringTokenizer kan bruges til at dele op i ord. 
  </P>
  <LI><P CLASS="western">Hvordan undg&aring;r du dubletter i
  ordlisten? Skriv programmet om s&aring; det fjerner dubletter.</P>
  <LI><P CLASS="western">Drop nu koden, der fjerner dubletter, men
  &aelig;ndr datastrukturen til at v&aelig;re en HashSet (har du
  problemer med at hente elementer ud af listen, s&aring; l&aelig;s
  <a href='kapitel1.jsp#afsn1.1.5'>afsnit 1.1.5</a> om <SPAN LANG="da-DK">iteratorer</SPAN>). Hvilken
  forskel g&oslash;r det? Hvad sker der med ordlisten?</P>
  <LI><P CLASS="western">&AElig;ndr datastrukturen til at v&aelig;re
  en TreeSet. <BR>Hvilken forskel g&oslash;r det? Hvad sker der med
  ordlistens r&aelig;kkef&oslash;lge?<BR>Pr&oslash;v ogs&aring; med en
  LinkedHashSet.</P>
  <LI><P CLASS="western">Lav et vindue med en grafisk
  brugergr&aelig;nseflade til dit ordliste-program:<BR><IMG SRC="bog2_html_2db00ff4.png" NAME="Grafik28" ALIGN=BOTTOM BORDER=0><BR>N&aring;r
  brugeren trykker p&aring; OK-knappen, skal ordlisten opdateres med
  de ord, den ikke allerede indeholder.</P>
  <LI><P CLASS="western">L&aelig;s kildeteksten til Vector, og pr&oslash;v
  at forst&aring; hvordan, den fungerer. Den kan findes i din
  java-installation (i filen <SPAN LANG="da-DK">src.zip</SPAN>) eller
  i <a href='kapitel1.jsp#afsn1.6.8'>afsnit 1.6.8</a>. <SPAN LANG="da-DK">Stud&eacute;r</SPAN> is&aelig;r
  de metoder, du er fortrolig med, som <SPAN LANG="da-DK">elementAt</SPAN>(),
  addElement(), <SPAN LANG="da-DK">insertElementAt</SPAN>() og
  <SPAN LANG="da-DK">removeElementAt</SPAN>().</P>
</OL>
<H2 CLASS="western">1.4 <a name='afsn1.4'></a>Videre l&aelig;sning</SPAN></H2>
<P CLASS="western">En introduktion til samlinger af data kan findes
p&aring;<BR>  
<SPAN STYLE="font-weight: medium"><A CLASS="western" HREF="http://developer.java.sun.com/developer/onlineTraining/collections/">http://<SPAN LANG="da-DK">developer.java.sun.com</SPAN>/developer/onlineTraining/collections/</A></SPAN>
</P>
<P CLASS="western">En anden, mere opgave-orienteret vejledning kan
findes p&aring; adressen<BR>  
<SPAN STYLE="font-weight: medium"><A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial/collections/index.html">http://java.sun.com/docs/books/tutorial/collections/<SPAN LANG="da-DK">index.html</SPAN></A></SPAN></P>
<H2 CLASS="western" STYLE="">1.5 <a name='afsn1.5'></a>Appendiks</SPAN></H2>
<P CLASS="western">Her er en komplet oversigt over og forklaring p&aring;
alle samlingerne af data og deres metoder.</P>
<H3 CLASS="western">1.5.1 <a name='afsn1.5.1'></a>Collection</H3>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet
<B>Collection</B> - f&aelig;llesn&aelig;vnerne for alle samlinger af
data (lister og m&aelig;ngder)</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>add</B>(Object)      f&oslash;jer et element til samlingen</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>remove</B>(Object)    fjerner et element, hvis det findes i
samlingen</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B><SPAN LANG="da-DK">addAll</SPAN></B>(Collection)    tilf&oslash;jer
elementerne fra en anden samling (foreningsm&aelig;ngde)</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B><SPAN LANG="da-DK">removeAll</SPAN></B>(Collection)  fjerner alle
elementer, der findes i en anden samling</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B><SPAN LANG="da-DK">retainAll</SPAN></B>(Collection)  fjerner alt,
der ikke ogs&aring; er i en anden samling (f&aelig;llesm&aelig;ngde)</P>
<P CLASS="klasseoversigt---kompakt-western"><I>ovenst&aring;ende
metoder returnerer true, hvis data &aelig;ndredes af operationen,
false hvis samlingen var up&aring;virket</I></P>
<P CLASS="klasseoversigt---kompakt-western">void <B>clear</B>()      t&oslash;mmer
samlingen for alle elementer</P>
<P CLASS="klasseoversigt---kompakt-western">int <B>size</B>()      giver
antal elementer</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>isEmpty</B>()      returnerer true, hvis der er 0 elementer</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>contains</B>(Object)    returnerer true, hvis elementet findes</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B><SPAN LANG="da-DK">containsAll</SPAN></B>(Collection)  returnerer
true, hvis alle elementerne findes</P>
<P CLASS="klasseoversigt---kompakt-western">Iterator
<B>iterator</B>()      giver en iterator (se <a href='kapitel1.jsp#afsn1.5.6'>afsnit 1.5.6</a>)</P>
<P CLASS="klasseoversigt---kompakt-western">Object[]
<B><SPAN LANG="da-DK">toArray</SPAN></B>()      giver et array med alle
elementerne</P>
<P CLASS="klasseoversigt---kompakt-western">Object[]
<B>toArray</B>(Object[])    l&aelig;gger alle elementer med en given
type i et eksisterende array</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>equals</B>(Object)    unders&oslash;ger lighed (samme type samling
med samme elementer)</P>
<H3 CLASS="western">1.5.2 <a name='afsn1.5.2'></a>Set</H3>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet
<B>Set</B> repr&aelig;senterer en m&aelig;ngde. Det arver fra
Collection, men tilf&oslash;jer ingen nye metoder.</I></FONT></P>

<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Klassen
<B>HashSet</B> implementerer Set (og dermed Collection), Cloneable og
Serializable og har konstrukt&oslash;rerne:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western"><B>HashSet</B>()    opretter
tom m&aelig;ngde med startkapacitet p&aring; ca. 10 elementer</P>
<P CLASS="klasseoversigt---kompakt-western"><B>HashSet</B>(int
startkapacitet)  opretter tom m&aelig;ngde med specificeret
startkapacitet</P>
<P CLASS="klasseoversigt---kompakt-western"><B>HashSet</B>(int 
startkapacitet, float <SPAN LANG="da-DK">maxFyldningsfaktor</SPAN>)
fyldningsfaktor =antal elementer/kapacitet</P>
<P CLASS="klasseoversigt---kompakt-western"><B>HashSet</B>(Collection)    opretter
m&aelig;ngde med alle elementer fra en anden samling</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>clone</B>()    laver
en overfladisk kopi (referencerne kopieres, ikke elementerne)</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Med
JDK1.4 kom klassen <B><SPAN LANG="da-DK">LinkedHashSet</SPAN></B>,
der tillader hurtigere genneml&oslash;b af n&oslash;glerne, men
ellers ikke adskiller sig fra HashSet.</I></FONT></P>
<H3 CLASS="western">1.5.3 <a name='afsn1.5.3'></a>SortedSet</H3>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet
<B>SortedSet</B> er en ordnet m&aelig;ngde. Det arver fra Set (og
dermed fra Collection) og tilf&oslash;jer metoderne:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>first</B>()      giver
f&oslash;rste element i m&aelig;ngden</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>last</B>()      giver
sidste element i m&aelig;ngden</P>
<P CLASS="klasseoversigt---kompakt-western">SortedSet <B><SPAN LANG="da-DK">tailSet</SPAN></B>(Object
fra)  giver alle elementer i m&aelig;ngden fra (og evt. med) elementet
<I>fra</I></P>
<P CLASS="klasseoversigt---kompakt-western">SortedSet <B>headSet</B>(Object
til)  giver alle elementer i m&aelig;ngden, der kommer f&oslash;r
elementet <I>til</I></P>
<P CLASS="klasseoversigt---kompakt-western">SortedSet <B>subSet</B>(Object
fra, Object til) giver kombinationen af headSet() og tailSet()</P>
<P CLASS="klasseoversigt---kompakt-western">Comparator
<B>comparator</B>()    giver ordningen (eller null, hvis
standardordning benyttes)</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm; ">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Klassen <B>TreeSet</B>
implementerer SortedSet (og dermed Set), Cloneable og Serializable og
har konstrukt&oslash;rerne:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western"><B>TreeSet</B>()    opretter
tom m&aelig;ngde</P>
<P CLASS="klasseoversigt---kompakt-western"><B>TreeSet</B>(Comparator)  opretter
tom m&aelig;ngde med specificeret ordning</P>
<P CLASS="klasseoversigt---kompakt-western"><B>TreeSet</B>(Collection)    opretter
m&aelig;ngde med alle elementer fra en samling af data</P>
<P CLASS="klasseoversigt---kompakt-western"><B>TreeSet</B>(SortedSet)    opretter
m&aelig;ngde med alle elementer fra en anden ordnet m&aelig;ngde</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>clone</B>()    laver
en overfladisk kopi (referencerne kopieres, ikke elementerne)</P>

<H3 CLASS="western">1.5.4 <a name='afsn1.5.4'></a>List</H3>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet
<B>List</B> repr&aelig;senterer en liste (hvor dubletter er tilladt).
Det arver fra Collection og tilf&oslash;jer metoderne:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">void <B>add</B>(int,
Object)    inds&aelig;tter element p&aring; bestemt plads i listen</P>
<P CLASS="klasseoversigt---kompakt-western">Object
<B>get</B>(int)    afl&aelig;ser, hvilket element der er p&aring; en
bestemt plads i listen</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>set</B>(int,
Object)  erstatter element p&aring; en bestemt plads (erstattet
element returneres)</P>
<P CLASS="klasseoversigt---kompakt-western">Object
<B>remove</B>(int)    fjerner element p&aring; en bestemt plads
(fjernet element returneres)</P>
<P CLASS="klasseoversigt---kompakt-western">boolean <B>addAll</B>(int,
Collection) inds&aelig;tter alle elementer fra en samling af data p&aring;
en bestemt plads</P>
<P CLASS="klasseoversigt---kompakt-western">int
<B><SPAN LANG="da-DK">indexOf</SPAN></B>(Object)    finder f&oslash;rste
position i listen, hvor et element optr&aelig;der</P>
<P CLASS="klasseoversigt---kompakt-western">int
<B><SPAN LANG="da-DK">lastIndexOf</SPAN></B>(Object)  finder sidste
position i listen, hvor et element optr&aelig;der</P>
<P CLASS="klasseoversigt---kompakt-western"><SPAN LANG="da-DK">ListIterator</SPAN>
<B><SPAN LANG="da-DK">listIterator</SPAN></B>()  giver en iterator (se
<a href='kapitel1.jsp#afsn1.5.6'>afsnit 1.5.6</a>) med udvidede muligheder</P>
<P CLASS="klasseoversigt---kompakt-western">ListIterator
<B>listIterator</B>(int)  giver en iterator (se <a href='kapitel1.jsp#afsn1.5.6'>afsnit 1.5.6</a>), der
starter fra en bestemt plads</P>
<P CLASS="klasseoversigt---kompakt-western">List <B>subList</B>(int,
int)    giver en delliste (&aelig;ndres i dellisten, &aelig;ndres ogs&aring;
i oprindelige liste)</P>

<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Klassen
<B>ArrayList</B>  implementerer List (og dermed Collection),
Cloneable, Serializable og har derudover:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western"><B>ArrayList</B>()    opretter
tom liste med startkapacitet p&aring; ca. 10 elementer</P>
<P CLASS="klasseoversigt---kompakt-western"><B>ArrayList</B>(int)    opretter
tom liste med specificeret startkapacitet</P>
<P CLASS="klasseoversigt---kompakt-western"><B>ArrayList</B>(Collection)  opretter
liste med alle elementer fra en anden samling af data</P>
<P CLASS="klasseoversigt---kompakt-western">void
<B><SPAN LANG="da-DK">trimToSize</SPAN></B>()    trimmer listen, s&aring;
kapaciteten lige netop kan rumme elementerne</P>
<P CLASS="klasseoversigt---kompakt-western">void <B><SPAN LANG="da-DK">ensureCapacity</SPAN></B>(int
kap) sikrer at kapacitet (antal elementer, listen kan rumme f&oslash;r
den er n&oslash;dt<BR>    til at udvide sig) er mindst <I>kap</I></P>
<P CLASS="klasseoversigt---kompakt-western" STYLE="font-style: normal">
Object <B>clone</B>()    laver en overfladisk kopi (referencerne
kopieres, ikke elementerne)</P>

<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Klassen
<B>LinkedList</B>  implementerer List (og dermed Collection),
Cloneable, Serializable og har derudover:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western"><B>LinkedList</B>()    opretter
en tom liste</P>
<P CLASS="klasseoversigt---kompakt-western"><B>LinkedList</B>(Collection)  opretter
en liste med alle elementer fra en anden samling af data</P>
<P CLASS="klasseoversigt---kompakt-western">void
<B><SPAN LANG="da-DK">addFirst</SPAN></B>(Object)  tilf&oslash;jer
f&oslash;rst i listen</P>
<P CLASS="klasseoversigt---kompakt-western">void
<B>a<SPAN LANG="da-DK">ddLast</SPAN></B>(Object)  tilf&oslash;jer
sidst i listen</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B><SPAN LANG="da-DK">getFirst</SPAN></B>()    giver
f&oslash;rste element</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B><SPAN LANG="da-DK">getLast</SPAN></B>()    giver
sidste element 
</P>
<P CLASS="klasseoversigt---kompakt-western">Object
<B><SPAN LANG="da-DK">removeFirst</SPAN></B>()    fjerner f&oslash;rste
element (fjernet element returneres)</P>
<P CLASS="klasseoversigt---kompakt-western">Object
<B><SPAN LANG="da-DK">removeLast</SPAN></B>()    fjerner sidste element
(fjernet element returneres)</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>clone</B>()    laver
en overfladisk kopi (referencerne kopieres, ikke elementerne)</P>

<H3 CLASS="western" STYLE="">1.5.5 <a name='afsn1.5.5'></a>Map</H3>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet
 <B>Map</B>  - f&aelig;llesn&aelig;vnerne for alle associative
tabeller (afbildninger)</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>put</B>(Object
n, Object v)  tilf&oslash;jer <I>v</I> under n&oslash;glen <I>n</I> 
(evt. erstattet v&aelig;rdi returneres)</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>get</B>(Object
n&oslash;gle)    finder v&aelig;rdien under <I>n&oslash;gle</I><SPAN STYLE="font-style: normal">
og returnerer v&aelig;rdien</SPAN></P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>remove</B>(Object
n&oslash;gle)   fjerner v&aelig;rdien under <I>n&oslash;gle</I> (evt.
fjernet v&aelig;rdi returneres)</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>containsKey</B>(Object n)  returnerer sand, hvis n&oslash;glen <I>n</I>
findes i afbildningen</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>containsValue</B>(Object v)  returnerer sand, hvis v&aelig;rdi <I>v</I>
findes i afbildningen</P>
<P CLASS="klasseoversigt---kompakt-western">void <B><SPAN LANG="da-DK">putAll</SPAN></B>(Map)      f&oslash;jer
alle indgange fra en anden afbildning til denne</P>
<P CLASS="klasseoversigt---kompakt-western">int <B>size</B>()      returnerer
antallet af indgange</P>
<P CLASS="klasseoversigt---kompakt-western">boolean <B>isEmpty</B>()      er
sand, hvis afbildningen er tom (indeholder 0 indgange)</P>
<P CLASS="klasseoversigt---kompakt-western">void <B>clear</B>()      t&oslash;mmer
afbildningen for alle elementer</P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>equals</B>(Object)    unders&oslash;ger lighed (afbildning med de
samme n&oslash;gle-v&aelig;rdi-par)</P>
<P CLASS="klasseoversigt---kompakt-western">Set <B>keySet</B>()      giver
m&aelig;ngde med alle n&oslash;gler</P>
<P CLASS="klasseoversigt---kompakt-western">Collection
<B>values</B>()      giver samlingen af v&aelig;rdierne (der kan v&aelig;re
dubletter)</P>
<P CLASS="klasseoversigt---kompakt-western">Set <B><SPAN LANG="da-DK">entrySet</SPAN></B>()      giver
m&aelig;ngde med n&oslash;gle-v&aelig;rdi-par (se <SPAN LANG="da-DK">Map.Entry</SPAN>
nedenfor)</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Klassen
<B>HashMap</B> implementerer Map, Cloneable, Serializable og har
konstrukt&oslash;rerne:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western"><B>HashMap</B>()      opretter
tom afbildning med startkapacitet p&aring; ca. 10 elementer</P>
<P CLASS="klasseoversigt---kompakt-western"><B>HashMap</B>(int
startkapacitet)   opretter tom afbildning med specificeret
startkapacitet</P>
<P CLASS="klasseoversigt---kompakt-western"><B>HashMap</B>(int 
startkapacitet, float <SPAN LANG="da-DK">maxFyldfaktor</SPAN>)
fyldfaktor =antal elementer/kapacitet</P>
<P CLASS="klasseoversigt---kompakt-western"><B>HashMap</B>(Map)      opretter
afbildning med alle indgange fra en anden afbildning</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>clone</B>()      laver
en overfladisk kopi (referencer kopieres, ikke elementer)</P>

<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet
<B>SortedMap</B> er en afbildning, der er ordnet efter n&oslash;glerne.
Det arver fra Set og tilf&oslash;jer metoderne:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">Object <B><SPAN LANG="da-DK">firstKey</SPAN></B>()      giver
f&oslash;rste n&oslash;gle i afbildningen</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B><SPAN LANG="da-DK">lastKey</SPAN></B>()      giver
sidste n&oslash;gle i afbildningen</P>
<P CLASS="klasseoversigt---kompakt-western">SortedMap <B><SPAN LANG="da-DK">tailMap</SPAN></B>(Object
fra)  giver en afbildning med alle n&oslash;gler fra (og evt. med) <I>fra</I></P>
<P CLASS="klasseoversigt---kompakt-western">SortedMap <B><SPAN LANG="da-DK">headMap</SPAN></B>(Object
til)   giver en afbildning med alle n&oslash;gler der kommer f&oslash;r
<I>til</I></P>
<P CLASS="klasseoversigt---kompakt-western">SortedMap <B><SPAN LANG="da-DK">subMap</SPAN></B>(Object
fra, Object til) kombinationen af tailMap() og headMap()</P>
<P CLASS="klasseoversigt---kompakt-western">Comparator
<B>comparator</B>()    giver ordningen (null hvis standardordning
benyttes)</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Klassen
<B>TreeMap</B> implementerer SortedMap (og dermed Map), Cloneable,
Serializable og har konstrukt&oslash;rerne:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western"><B>TreeMap</B>()      opretter
tom afbildning</P>
<P CLASS="klasseoversigt---kompakt-western"><B>TreeMap</B>(Comparator)    opretter
tom afbildning med specificeret ordning</P>
<P CLASS="klasseoversigt---kompakt-western"><B>TreeMap</B>(Map)      opretter
afbildning med alle indgange fra en anden afbildning</P>
<P CLASS="klasseoversigt---kompakt-western"><B>TreeMap</B>(SortedMap)    opretter
afbildning fra en anden ordnet afbildning</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>clone</B>()      laver
overfladisk kopi (referencerne kopieres, ikke elementerne)</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Metoden
entrySet() giver m&aelig;ngden af alle indgangene i afbildningen,
repr&aelig;senteret ved interfacet <B>Map.Entry</B>:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">Object <B><SPAN LANG="da-DK">getKey</SPAN></B>()      giver
n&oslash;glen</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B><SPAN LANG="da-DK">getValue</SPAN></B>()      giver
v&aelig;rdien</P>
<P CLASS="klasseoversigt---kompakt-western">Object
<B><SPAN LANG="da-DK">setValue</SPAN></B>(Object)    s&aelig;tter
v&aelig;rdien (erstattet v&aelig;rdi returneres)</P>
<H3 CLASS="western" STYLE="">1.5.6 <a name='afsn1.5.6'></a>Iteratorer</H3>
<P CLASS="western">En iterator er et lille objekt, der hj&aelig;lper
en med at genneml&oslash;be nogle data (se <a href='kapitel1.jsp#afsn1.1.5'>afsnit 1.1.5</a>). Man kan man
f&aring; et iterator-objekt ved at kalde metoden iterator() p&aring;
enhver samling af data:</P>
<PRE CLASS="kode-western">Iterator <B>iter = samling.iterator()</B>;
while (<B>iter.hasNext()</B>) 
{
  String s = (String) <B>iter.next()</B>;
  <I>// g&oslash;r noget med s</I>
}</PRE>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet
<B>Iterator</B>:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B>hasNext</B>()    returnerer sand, hvis der er flere elementer</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>next</B>()    g&aring;r
til n&aelig;ste element og returnerer det</P>
<P CLASS="klasseoversigt---kompakt-western">void <B>remove</B>()    fjerner
aktuelle element fra samlingen (ikke altid implementeret)</P>

<P CLASS="western">Til lister (af typen List) kan man f&aring; et
udvidet iterator-objekt ved at kalde listIterator():</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet
<B>ListIterator</B> arver fra Iterator og har derudover metoderne:</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B><SPAN LANG="da-DK">hasPrevious</SPAN></B>()  returnerer sand, hvis
der er tidligere elementer</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B>previous</B>()    g&aring;r
til n&aelig;ste element og returnerer det</P>
<P CLASS="klasseoversigt---kompakt-western">int <B><SPAN LANG="da-DK">nextIndex</SPAN></B>()    giver
indeks p&aring; element, der ville returneres af next()</P>
<P CLASS="klasseoversigt---kompakt-western">int
<B><SPAN LANG="da-DK">previousIndex</SPAN></B>()    giver indeks p&aring;
element, der ville returneres af previous()</P>
<P CLASS="klasseoversigt---kompakt-western">void
<B>set</B>(Object)    erstatter det aktuelle element i listen med et
andet</P>
<P CLASS="klasseoversigt---kompakt-western">void
<B>add</B>(Object)    inds&aelig;tter element lige f&oslash;r n&aelig;ste
element i listen</P>

<P CLASS="western">N&aring;r en iterator bruges p&aring; en samling,
er det ulovligt at &aelig;ndre samlingen strukturelt (f.eks. inds&aelig;tte
eller slette elementer) direkte, da <SPAN LANG="da-DK">iteratoren</SPAN>
derved kommer ud af trit med samlingen. Kommer en iterator ud af trit
med sin samling, er den ubrugelig og vil kaste undtagelsen
<SPAN LANG="da-DK">ConcurrentModificationException</SPAN>, hvis
next() nogen sinde kaldes p&aring; den igen. 
</P>
<P CLASS="western">&Oslash;nsker man at &aelig;ndre i samlingen
samtidig med at man bruger en iterator, b&oslash;r man derfor bruge
<SPAN LANG="da-DK">iteratorens</SPAN> &aelig;ndringsmetoder.</P>
<H4 CLASS="western">Enumeration</H4>
<P CLASS="western">Da Iterator og ListIterator kom f&oslash;rst til
med JDK 1.2 bruges I standardbiblioteket ofte som iterator et
Enumeration-objekt (p&aring; dansk 'opremsning') i stedet, f.eks.:</P>
<PRE CLASS="kode-western">Enumeration <B><SPAN LANG="da-DK">enum</SPAN> = <SPAN LANG="da-DK">vektor.elements</SPAN>()</B>;
while (<B><SPAN LANG="da-DK">enum.hasMoreElements</SPAN>()</B>)
{
  String s = (String) <B><SPAN LANG="da-DK">enum.nextElement</SPAN>()</B>;
  // g&oslash;r noget med s
}</PRE><P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Interfacet <B>Enumeration</B>
- har eksisteret l&aelig;ngere end Iterator og findes derfor ofte
brugt i standardbiblioteket</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">boolean
<B><SPAN LANG="da-DK">hasMoreElements</SPAN></B>()  returnerer sand,
hvis der er flere elementer</P>
<P CLASS="klasseoversigt---kompakt-western">Object <B><SPAN LANG="da-DK">nextElement</SPAN></B>()    g&aring;r
til n&aelig;ste element og returnerer det</P>

<H3 CLASS="western" STYLE="">1.5.7 <a name='afsn1.5.7'></a>Manipulation
og sortering af data</H3>
<P CLASS="western">Der findes en r&aelig;kke metoder til at
manipulere og sortere array af data i klassen Arrays.</P>

<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Klassen
<B>Arrays</B> - alskens metoder til at arbejde med array.</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>sort</B>(double*[])          sorterer array af simpel type (ogs&aring;
m. byte, int, ...)</P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>sort</B>(double*[], int fra, int til)    sorterer arrayet fra og med
plads nr. <I>fra</I><SPAN STYLE="font-style: normal"> til plads nr.
</SPAN><I>til</I></P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>sort</B>(Object[])          sorterer array af objekter</P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>sort</B>(Object[], int fra, int til)      sorterer arrayet fra og med
plads nr. <I>fra</I><SPAN STYLE="font-style: normal"> til plads nr.
</SPAN><I>til</I></P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>sort</B>(Object[], Comparator)      sorterer array af objekter efter
en bestemt ordning</P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>sort</B>(Object[], int, int, Comparator) sorterer arrayet fra og
med plads nr. <I>fra</I><SPAN STYLE="font-style: normal"> til plads
nr. </SPAN><I>til</I></P>

<P CLASS="klasseoversigt---kompakt-western">static int
<B><SPAN LANG="da-DK">binarySearch</SPAN></B>(double*[],
double*)  s&oslash;ger (bin&aelig;rt) i allerede sorteret array af
simpel type</P>
<P CLASS="klasseoversigt---kompakt-western">static int
<B>binarySearch</B>(Object[], Object)    s&oslash;ger (bin&aelig;rt) i
allerede sorteret array af objekter</P>
<P CLASS="klasseoversigt---kompakt-western">static int
<B>binarySearch</B>(Object[], Object, Comparator) s&oslash;ger i
array sorteret med bestemt ordning</P>

<P CLASS="klasseoversigt---kompakt-western">static boolean
<B>equals</B>(double*[], double*[])  lighed af to array af simpel type
(ogs&aring; m. byte, int, ...)</P>
<P CLASS="klasseoversigt---kompakt-western">static boolean
<B>equals</B>(Object[], Object[])    unders&oslash;ger, om to array har
de samme objekter</P>

<P CLASS="klasseoversigt---kompakt-western">static void
<B>fill</B>(double*[], double*)        s&aelig;tter alle pladser til en
bestemt v&aelig;rdi (ogs&aring; m. <SPAN LANG="da-DK">int..</SPAN>)</P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>fill</B>(double*[], int, int, double*)  s&aelig;tter v&aelig;rdier
fra og med plads nr. <I>fra</I><SPAN STYLE="font-style: normal"> til
plads nr. </SPAN><I>til</I></P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>fill</B>(Object[], Object)        s&aelig;tter alle pladser i arrayet
til et bestemt objekt</P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>fill</B>(Object[], int, int, Object)     fylder med objekt fra og
med plads nr. <I>fra</I><SPAN STYLE="font-style: normal"> til nr. </SPAN><I>til</I></P>

<P CLASS="klasseoversigt---kompakt-western">static List
<B><SPAN LANG="da-DK">asList</SPAN></B>(Object[])          laver en liste
ud fra et array af objekter</P>

<P CLASS="klasseoversigt---kompakt-western"><I>*) betyder, at metoden
findes b&aring;de med parameter af typen boolean, byte, char, int,
float og double</I></P>

<P CLASS="western">Her er et eksempel p&aring; brug af nogle af
funktionerne:</P>
<PRE CLASS="kode-western">import java.util.*;

public class <SPAN LANG="da-DK">BenytArrays</SPAN>
{
  public static void main(String[] args)
  {
    int[] tal = new int[20];
    <SPAN LANG="da-DK">Arrays.fill</SPAN>(tal,42);        <I>// s&aelig;t alle elementerne i arrayet til 42</I>
    Arrays.fill(tal,5,15,44);   <I>// s&aelig;t plads 5 til og med plads nr. 14 til 44</I>
    tal[10] = 43;               <I>// s&aelig;t plads nr 10 til 43</I>
    <SPAN LANG="da-DK">Arrays.sort</SPAN>(tal);           <I>// <SPAN LANG="da-DK">sort&eacute;r</SPAN> array (for f.eks. at kunne s&oslash;ge i det)</I>

    int pos44 = <SPAN LANG="da-DK">Arrays.binarySearch</SPAN>(tal,44); <I>// hvad er nu index p&aring; tallet 44?</I>
    System.out.println( &quot;Tallet 44 er p&aring; plads nr: &quot; + pos44 );
  }
}</PRE>
<HR>
<PRE CLASS="kode-western" STYLE="font-style: normal; font-weight: medium">Tallet 44 er p&aring; plads nr: 14</PRE>
<P CLASS="western">Bem&aelig;rk, at vil man kopiere et array af
objekter g&oslash;res det mest effektivt med metoden      
System.arraycopy().</P>
<P CLASS="western" STYLE="">Ligeledes findes
metoder til at manipulere og sortere lister, m&aelig;ngder og
afbildninger:</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Klassen
<B>Collections</B>  - alskens metoder til at arbejde med samlinger af
data.</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">static final Set
<B>EMPTY_SET</B><SPAN STYLE="font-weight: medium">      repr&aelig;senterer
en tom m&aelig;ngde</SPAN><BR>static final List
<B>EMPTY_LIST</B><SPAN STYLE="font-weight: medium">    repr&aelig;senterer
en tom liste<BR></SPAN>static final Map <B>EMPTY_MAP  </B>  repr&aelig;senterer
en tom afbildning</P>

<P CLASS="klasseoversigt---kompakt-western">static void
<B>sort</B>(List)        sorterer listen<BR>static void <B>sort</B>(List,
Comparator)     sorterer listen efter en bestemt ordning</P>

<P CLASS="klasseoversigt---kompakt-western">static int
<B>binarySearch</B>(List, Object)   giver indeks p&aring; et objekt
ved bin&aelig;r s&oslash;gning i en sorteret liste</P>
<P CLASS="klasseoversigt---kompakt-western">static int
<B>binarySearch</B>(List, Object, Comparator) s&oslash;ger i en
sorteret (med bestemt ordning) liste</P>

<P CLASS="klasseoversigt---kompakt-western">static void
<B>reverse</B>(List)      vender r&aelig;kkef&oslash;lgen af alle
elementerne i listen om</P>
<P CLASS="klasseoversigt---kompakt-western">static void
<B>shuffle</B>(List)      blander listen, s&aring; elementerne kommer i
tilf&aelig;ldig r&aelig;kkef&oslash;lge</P>
<P CLASS="klasseoversigt---kompakt-western">static void <B>shuffle</B>(List,
Random)    blander listen<SPAN LANG="da-DK"> v.hj.a. </SPAN>et
specificeret Random-objekt</P>
<P CLASS="klasseoversigt---kompakt-western">static void <B>fill</B>(List,
Object)      erstatter alle pladser i listen med det samme element</P>
<P CLASS="klasseoversigt---kompakt-western">static void <B>copy</B>(List
til, List fra)    kopierer liste. Til-listen skal have plads til
elementerne.</P>

<P CLASS="klasseoversigt---kompakt-western">static Object
<B>min</B>(Collection)    finder mindste element</P>
<P CLASS="klasseoversigt---kompakt-western">static Object
<B>min</B>(Collection, Comparator) finder mindste element (i forhold
til en bestemt ordning)</P>
<P CLASS="klasseoversigt---kompakt-western">static Object
<B>max</B>(Collection)    finder st&oslash;rste element</P>
<P CLASS="klasseoversigt---kompakt-western">static Object
<B>max</B>(Collection, Comparator) finder st&oslash;rste element (i
forhold til en bestemt ordning)</P>

<P CLASS="klasseoversigt---kompakt-western">static Collection
<B><SPAN LANG="da-DK">unmodifiableCollection</SPAN></B>(Collection)
    laver en uforanderlig samling<BR>static Set
<B><SPAN LANG="da-DK">unmodifiableSet</SPAN></B>(Set)                laver en
uforanderlig m&aelig;ngde<BR>static SortedSet
<B><SPAN LANG="da-DK">unmodifiableSortedSet</SPAN></B>(SortedSet)
      laver en uforanderlig sorteret m&aelig;ngde<BR>static List
<B><SPAN LANG="da-DK">unmodifiableList</SPAN></B>(List)                laver
en uforanderlig liste<BR>static Map <B><SPAN LANG="da-DK">unmodifiableMap</SPAN></B>(Map)              laver
en uforanderlig afbildning<BR>static SortedMap
<B><SPAN LANG="da-DK">unmodifiableSortedMap</SPAN></B>(SortedMap)  laver
uforanderlig sorteret afbildning</P>

<P CLASS="klasseoversigt---kompakt-western">static Collection
<B><SPAN LANG="da-DK">synchronizedCollection</SPAN></B>(Collection)    laver
en <SPAN LANG="da-DK">tr&aring;dsikker</SPAN> samling<BR>static Set
<B><SPAN LANG="da-DK">synchronizedSet</SPAN></B>(Set)                laver en
tr&aring;dsikker m&aelig;ngde<BR>static SortedSet
<B><SPAN LANG="da-DK">synchronizedSortedSet</SPAN></B>(SortedSet)      laver
en tr&aring;dsikker sorteret m&aelig;ngde<BR>static List
<B><SPAN LANG="da-DK">synchronizedList</SPAN></B>(List)                laver
en tr&aring;dsikker liste<BR>static Map
<B><SPAN LANG="da-DK">synchronizedMap</SPAN></B>(Map)              laver en
tr&aring;dsikker afbildning<BR>static SortedMap
<B><SPAN LANG="da-DK">synchronizedSortedMap</SPAN></B>(SortedMap)
  laver en tr&aring;dsikker sorteret afbildning</P>

<P CLASS="klasseoversigt---kompakt-western">static Set
<B>singleton</B>(Object)          laver en uforanderlig m&aelig;ngde med
&eacute;t element</P>
<P CLASS="klasseoversigt---kompakt-western">static List
<B><SPAN LANG="da-DK">singletonList</SPAN></B>(Object)        laver en
uforanderlig liste med &eacute;t element</P>
<P CLASS="klasseoversigt---kompakt-western">static Map
<B><SPAN LANG="da-DK">singletonMap</SPAN></B>(Object, Object)    laver
en uforanderlig afbildning med &eacute;n indgang</P>

<P CLASS="klasseoversigt---kompakt-western">static List <B><SPAN LANG="da-DK">nCopies</SPAN></B>(int
n, Object <SPAN LANG="da-DK">elem</SPAN>)      laver en uforanderlig
liste med <I>n</I> kopier af <I>elem</I></P>
<P CLASS="klasseoversigt---kompakt-western">static Comparator
<B><SPAN LANG="da-DK">reverseOrder</SPAN></B>()        giver den omvendte
ordning af den naturlige ordning</P>
<P CLASS="klasseoversigt---kompakt-western">static Enumeration
<B>enumeration</B>(Collection)  giver en opremsning (Enumeration) af
en samling</P>
<H2 CLASS="western">1.6 <a name='afsn1.6'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6">
  <input type='checkbox' name='vis' value='1.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">1.6.1 <a name='afsn1.6.1'></a>Store-O-notationen</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6.1">
  <input type='checkbox' name='vis' value='1.6.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">1.6.2 <a name='afsn1.6.2'></a>Arraybaserede listers virkem&aring;de</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6.2">
  <input type='checkbox' name='vis' value='1.6.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western" STYLE="">1.6.3 <a name='afsn1.6.3'></a>H&aelig;gtede
listers virkem&aring;de</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6.3">
  <input type='checkbox' name='vis' value='1.6.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">1.6.4 <a name='afsn1.6.4'></a>Hashtabellers virkem&aring;de</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6.4">
  <input type='checkbox' name='vis' value='1.6.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">1.6.5 <a name='afsn1.6.5'></a>S&oslash;getr&aelig;ers virkem&aring;de</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6.5">
  <input type='checkbox' name='vis' value='1.6.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">1.6.6 <a name='afsn1.6.6'></a>Uforanderlige samlinger</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6.6">
  <input type='checkbox' name='vis' value='1.6.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">1.6.7 <a name='afsn1.6.7'></a>Tr&aring;dsikre samlinger</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6.7">
  <input type='checkbox' name='vis' value='1.6.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western" STYLE="">1.6.8 <a name='afsn1.6.8'></a>Uddrag af
kildeteksten til Vector-klassen</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel1.jsp#afsn1.6.8">
  <input type='checkbox' name='vis' value='1.6.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='1.6.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Der
  er egentlig en tredje metode i Iterator, remove(), der fjerner det
  element, der sidst blev returneret af next(), men den bliver ikke
  behandlet her. Til lister (af typen List) kan man f&aring; et
  udvidet iterator-objekt ved at kalde listIterator(). Disse ting
  diskuteres i appendiks 1.5.6.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Til
  udskrivning af hele indholdet af en hashtabel er det lidt hurtigere
  at hente m&aelig;ngden af alle indgange (med b&aring;de n&oslash;gle
  og v&aelig;rdi) ved at kalde hashtabel.entrySet(). Se <a href='kapitel1.jsp#afsn1.5.5'>afsnit 1.5.5</a>.</P>
</DIV>
<DIV ID="sdfootnote3">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote3sym" HREF="#sdfootnote3anc">3</A>En
  n&aelig;rmere diskussion af, hvad en proxy og et uforanderligt
  objekt er, findes i hhv. <a href='kapitel17.jsp#afsn17.1'>afsnit 17.1</a> og <a href='kapitel18.jsp#afsn18.1'>afsnit 18.1</a>.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel0.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (71% af vrket).
</font>
<br>
nsker du at se de sidste 29% af dette vrk (362838 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
